// SetPaths.cpp : implementation file
//

#include "stdafx.h"
#include "GhostsConverter.h"
#include "SetPaths.h"


// CSetPaths dialog

IMPLEMENT_DYNAMIC(CSetPaths, CDialog)
CSetPaths::CSetPaths(CWnd* pParent /*=NULL*/)
	: CDialog(CSetPaths::IDD, pParent)
    , s_oldDefrag(_T(""))
    , s_newDefrag(_T(""))
    {
}

CSetPaths::~CSetPaths()
{
}

void CSetPaths::DoDataExchange(CDataExchange* pDX)
{
CDialog::DoDataExchange(pDX);
DDX_Text(pDX, IDC_OLDDEFRAG, s_oldDefrag);
DDX_Text(pDX, IDC_NEWDEFRAG, s_newDefrag);
}


BEGIN_MESSAGE_MAP(CSetPaths, CDialog)
    ON_BN_CLICKED(IDSET, OnBnClickedSet)
    ON_BN_CLICKED(IDC_BROWSEOLD, OnBnClickedBrowseold)
    ON_BN_CLICKED(IDC_BROWSENEW, OnBnClickedBrowsenew)
END_MESSAGE_MAP()


// CSetPaths message handlers

BOOL CSetPaths::OnInitDialog()
{
	CDialog::OnInitDialog();

    return TRUE;
}

void CSetPaths::OnBnClickedSet()
{
    UpdateData(TRUE);
    if(s_oldDefrag == "" || s_newDefrag == "")
        AfxMessageBox( _T( "The two paths must be set" ), MB_OK | MB_ICONEXCLAMATION );
    else
    {
        OnOK();
    }
}

void CSetPaths::OnBnClickedBrowseold()
{
    CString s_Path;
    if((s_Path = OnBrowse()) != "")
    {
        s_oldDefrag = s_Path;
        UpdateData(FALSE);
    }
}

void CSetPaths::OnBnClickedBrowsenew()
{
    CString s_Path;
    if((s_Path = OnBrowse()) != "")
    {
        s_newDefrag = s_Path;
        UpdateData(FALSE);
    }  
}

CString CSetPaths::OnBrowse()
{
    char path[MAX_PATH];
    CString s_Path;
    s_Path = "";

    BROWSEINFO bi = { 0 };
	LPITEMIDLIST pidl = SHBrowseForFolder ( &bi );
	if ( pidl != 0 )
	{
		// get the name of the folder
		SHGetPathFromIDList(pidl, path);
		s_Path = path;
    
		// free memory used
		IMalloc * imalloc = 0;
		if ( SUCCEEDED( SHGetMalloc ( &imalloc )) )
		{
			imalloc->Free ( pidl );
			imalloc->Release ( );
		}
	}
    return s_Path;
}
