// GhostsConverterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "GhostsConverter.h"
#include "GhostsConverterDlg.h"

#include "SetPaths.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//using System;
//using System.IO;
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
    ON_WM_RBUTTONUP( )
	ON_WM_LBUTTONUP( )
END_MESSAGE_MAP()

void CAboutDlg::OnRButtonUp(UINT nFlags, CPoint point){	OnOK(); }
void CAboutDlg::OnLButtonUp(UINT nFlags, CPoint point){	OnOK(); }


// CGhostsConverterDlg dialog



CGhostsConverterDlg::CGhostsConverterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGhostsConverterDlg::IDD, pParent)
    , s_Console(_T(""))
    {
	m_hIcon = AfxGetApp()->LoadIcon(IDI_BUNNY);

    s_oldDefrag = "";
    s_newDefrag = "";
    n_vq3grecFilesNb = 0;
    n_cpmgrecFilesNb = 0;
    bErrors = FALSE;
}

void CGhostsConverterDlg::DoDataExchange(CDataExchange* pDX)
{
CDialog::DoDataExchange(pDX);
DDX_Text(pDX, IDC_CONSOLE, s_Console);
DDX_Control(pDX, IDC_CONSOLE, mConsole);
}

BEGIN_MESSAGE_MAP(CGhostsConverterDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_BN_CLICKED(IDOK, OnBnClickedOk)
    ON_BN_CLICKED(IDC_SETPATHS, OnBnClickedSetpaths)
END_MESSAGE_MAP()


// CGhostsConverterDlg message handlers

BOOL CGhostsConverterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		//strAboutMenu.LoadString(IDS_ABOUTBOX);
        strAboutMenu = "About...";
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

    OnInit();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGhostsConverterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGhostsConverterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGhostsConverterDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CGhostsConverterDlg::OnInit()
{
    s_Console += "Init ...\r\n";
    SaveInRegistry();

    n_vq3grecFilesNb = CheckGrecFiles(s_oldDefrag + "\\ghosts\\*.grec");
    CString str;
    str.Format("Number of Old Vq3 Ghosts : %d at ", n_vq3grecFilesNb);
    str += s_oldDefrag;
    s_Console += str + "\r\n";

    UpdateData(FALSE);

    n_cpmgrecFilesNb = CheckGrecFiles(s_oldDefrag + "\\ghosts_cpm\\*.grec");
    str.Format("Number of Old CPM Ghosts : %d at ", n_cpmgrecFilesNb);
    str += s_oldDefrag; 
    s_Console += str + "\r\n\r\n";

    s_Console += "OK ... Waiting for user ...\r\n\r\n";

	UpdateData(FALSE);
}

void CGhostsConverterDlg::SaveInRegistry()
{
    CWinApp* pApp = AfxGetApp();
    
    VERIFY( pApp->WriteProfileString("Paths", "OldDefrag", s_oldDefrag) );
    VERIFY( pApp->WriteProfileString("Paths", "NewDefrag", s_newDefrag) );
}

UINT CGhostsConverterDlg::CheckGrecFiles(CString s_str)
{   
    int j = 0;
    CFileFind finder;
	if(finder.FindFile(s_str))
	{
		while(finder.FindNextFile()) j++;
        j++;
	}
	finder.Close();
	return j;
}

void CGhostsConverterDlg::OnBnClickedOk()
{
    CString sStr;
    CString sFinal;
    int nb;

    bErrors = FALSE;

    if(AfxMessageBox("Are you sure you want to convert ghosts ?\r\n\r\nYou should back up your old ghosts before.", MB_OKCANCEL | MB_ICONEXCLAMATION) == IDOK)
    {
        CFileFind finder;
        if(!finder.FindFile(s_newDefrag + "\\system\\ghosts\\"))
        {
            CreateDirectory(s_newDefrag + "\\system\\ghosts\\", NULL);
        }
        finder.Close();

        nb = NormalizeVq3Ghosts();    
        sStr.Format("Number of Vq3 .Grec Renamed, Edited and Moved : %d\t\r\n\r\n", nb);
        sFinal = sStr;
        s_Console += sStr;
        UpdateData(FALSE);
        mConsole.LineScroll(65535);

        nb = NormalizeVq3Boo();    
        sStr.Format("Number of Vq3 .boo_01 Renamed and Moved : %d\r\n", nb);
        s_Console += sStr;
        UpdateData(FALSE);
        mConsole.LineScroll(65535);

        s_Console += "\r\n\r\n";

        nb = NormalizeCpmGhosts();    
        sStr.Format("Number of Cpm .Grec Renamed, Edited and Moved : %d\t\r\n\r\n", nb);
        sFinal += sStr + "\r\n\r\n";
        s_Console += sStr;
        UpdateData(FALSE);
        mConsole.LineScroll(65535);

        nb = NormalizeCpmBoo();    
        sStr.Format("Number of Cpm .boo_01 Renamed and Moved : %d\r\n", nb);
        s_Console += sStr;
        s_Console += "\r\n\r\nOK ... Waiting for user ...\r\n\r\n";
        UpdateData(FALSE);
        mConsole.LineScroll(65535);

        if(bErrors) sFinal += "There was/were error(s). Check console for informations.\t";
        else 
        {
            sFinal += "It is now safe to delete your ghosts and ghosts_cpm folders\t\r\n";
            sFinal += "under the defrag folder.\r\n";
            sFinal += "(Make sure they are empty).";
        }    
        AfxMessageBox(sFinal, MB_OK | MB_ICONINFORMATION);
    }
}

int CGhostsConverterDlg::NormalizeVq3Ghosts()
{
    int i = 0;
    CFileFind finder;
    CString s_str(s_oldDefrag + "\\ghosts\\*.grec");
	if(finder.FindFile(s_str))
	{
		while(finder.FindNextFile()) if(MoveAndRenameGrec(&finder, "vq3")) i++;
        if(MoveAndRenameGrec(&finder, "vq3")) i++;
	}
	finder.Close();

    return i;
}

int CGhostsConverterDlg::NormalizeVq3Boo()
{
    int i = 0;
    CFileFind finder;
    CString s_str(s_oldDefrag + "\\ghosts\\*.boo_01");
	if(finder.FindFile(s_str))
	{
		while(finder.FindNextFile()) if(MoveAndRenameBoo(&finder, "vq3")) i++;
        if(MoveAndRenameBoo(&finder, "vq3")) i++;
	}
	finder.Close();

    return i;
}

int CGhostsConverterDlg::NormalizeCpmGhosts()
{
    int i = 0;
    CFileFind finder;
    CString s_str(s_oldDefrag + "\\ghosts_cpm\\*.grec");
	if(finder.FindFile(s_str))
	{
		while(finder.FindNextFile()) if(MoveAndRenameGrec(&finder, "cpm")) i++;
        if(MoveAndRenameGrec(&finder, "cpm")) i++;
	}
	finder.Close();

    return i;
}

int CGhostsConverterDlg::NormalizeCpmBoo()
{
    int i = 0;
    CFileFind finder;
    CString s_str(s_oldDefrag + "\\ghosts_cpm\\*.boo_01");
	if(finder.FindFile(s_str))
	{
		while(finder.FindNextFile()) if(MoveAndRenameBoo(&finder, "cpm")) i++;
        if(MoveAndRenameBoo(&finder, "cpm")) i++;
	}
	finder.Close();

    return i;
}

BOOL CGhostsConverterDlg::MoveAndRenameGrec(CFileFind *finder, CString sType)
{
    BOOL bRet = FALSE;
    CString sNewFilePath(s_newDefrag + "\\system\\ghosts\\");

    CString sOldFilePath;
    sOldFilePath = finder->GetFilePath();

    CString sFile;
    CString sOldFile;
    CString sFileName;
    sOldFile = finder->GetFileTitle();
    sFile = sOldFile + "_df_" + sType;
    sFileName = sFile + ".grec";

    CString sNewFileName;
    sNewFileName = sNewFilePath + sFileName;

    bRet = MoveFile(sOldFilePath, sNewFileName);
    if(!bRet)
    {
        LPVOID lpMsgBuf;
        FormatMessage( 
            FORMAT_MESSAGE_ALLOCATE_BUFFER | 
            FORMAT_MESSAGE_FROM_SYSTEM | 
            FORMAT_MESSAGE_IGNORE_INSERTS,
            NULL,
            GetLastError(),
            MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
            (LPTSTR) &lpMsgBuf,
            0,
            NULL 
        );
        // Process any inserts in lpMsgBuf.
        // ...
        // Display the string.
        //MessageBox((LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
        s_Console += "*Error* : \"" + sOldFilePath + "\" -> " + (LPCTSTR)lpMsgBuf;
        UpdateData(FALSE);
        bErrors = TRUE;
        // Free the buffer.
        LocalFree( lpMsgBuf );
    }
    else
    {
        ChangeContentsOfFile(sNewFileName, sType);
        s_Console += "OK : \"" + sOldFile + "\" Renamed to \"" + sFile + "\" And moved to \"" + sNewFilePath + "\"\r\n";
        UpdateData(FALSE);
    }

    return bRet;
}

BOOL CGhostsConverterDlg::MoveAndRenameBoo(CFileFind *finder, CString sType)
{
    BOOL bRet = FALSE;
    CString sNewFileName(s_newDefrag + "\\system\\ghosts\\");

    CString sOldFileName;
    sOldFileName = finder->GetFilePath();

    CString sStr;
    sStr = finder->GetFileTitle();
    char OldName[256] = {0};
    _tcscpy(OldName, sStr);

    int size = strlen(OldName) - 2;
    char buf[3];
    buf[0] = OldName[size];
    buf[1] = OldName[size+1];
    OldName[size] = buf[2] = 0;

    sStr = OldName;
    sStr += "df_" + sType + "_";
    sStr += buf;
    sNewFileName += sStr + ".boo_01";
    
    bRet = MoveFile(sOldFileName, sNewFileName);
    if(!bRet)
    {
        LPVOID lpMsgBuf;
        FormatMessage( 
            FORMAT_MESSAGE_ALLOCATE_BUFFER | 
            FORMAT_MESSAGE_FROM_SYSTEM | 
            FORMAT_MESSAGE_IGNORE_INSERTS,
            NULL,
            GetLastError(),
            MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
            (LPTSTR) &lpMsgBuf,
            0,
            NULL 
        );
        // Process any inserts in lpMsgBuf.
        // ...
        // Display the string.
        //MessageBox((LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
        s_Console += "*Error* : \"" + sOldFileName + "\" -> " + (LPCTSTR)lpMsgBuf;
        UpdateData(FALSE);
        bErrors = TRUE;
        // Free the buffer.
        LocalFree( lpMsgBuf );
    }

    return bRet;
}

BOOL CGhostsConverterDlg::ChangeContentsOfFile(CString sGhost, CString sType)
{
    BOOL bRet = FALSE;
    
    char Ghost[260] = {0};
    _tcscpy(Ghost, sGhost);
    char Type[260] = {0};
    _tcscpy(Type, sType + "_");

    FILE* mFile;

    if( mFile = fopen(Ghost, "r") )
    {
        bRet = TRUE;
        char buffer[512] = {0};
        fread(buffer, sizeof(char), 512, mFile);
        fclose(mFile);

        int i = 0;
        char mapName[256] = {0};
        while(buffer[i] != ' ') mapName[i] = buffer[i++];
        char lereste[256] = {0};
        int j = 0;
        while(buffer[i]) lereste[j++] = buffer[i++];
        char ghostNumber[3];
        ghostNumber[0] = mapName[strlen(mapName) - 2];
        ghostNumber[1] = mapName[strlen(mapName) - 1];
        ghostNumber[2] = 0;
        mapName[strlen(mapName)-2] = 0;
        strcat(mapName, "df_");
        strcat(mapName, Type);
        strcat(mapName, ghostNumber);
        strcat(mapName, lereste);
    
        SetFileAttributes(Ghost, FILE_ATTRIBUTE_NORMAL);    

        mFile = fopen(Ghost, "w");
        fwrite(mapName, sizeof(char), strlen(mapName), mFile);
        fclose(mFile);
    }
    return bRet;
}

void CGhostsConverterDlg::OnBnClickedSetpaths()
{
    n_vq3grecFilesNb = 0;
    n_cpmgrecFilesNb = 0;

    CSetPaths m_SetPathsDlg;
    m_SetPathsDlg.s_oldDefrag = s_oldDefrag;
    m_SetPathsDlg.s_newDefrag = s_newDefrag;

    BOOL bFound = FALSE;

    while(!bFound && (m_SetPathsDlg.DoModal() == IDOK)) bFound = CheckThesePath(m_SetPathsDlg.s_oldDefrag, m_SetPathsDlg.s_newDefrag);

    if(bFound)
    {
        s_oldDefrag = m_SetPathsDlg.s_oldDefrag;
        s_newDefrag = m_SetPathsDlg.s_newDefrag;
        OnInit();
    }
    mConsole.LineScroll(65535);
}
